#!/usr/bin/perl

use strict;
use warnings;
use CGI;
use Cards;

# sequence.pl.cgi - draw board for Sequence game.
# Copyright (C) 2003 Daniel Allen da@coder.com
# All rights reserved.
#
# The board-game name Sequence is a copyright of Jax, Ltd. (jaxgames.com).


my @suits = qw(S H C D S H C D);
my @names = ((2 .. 10), qw(K Q A));

my @deltaXForSide = (1,0,-1,0); # matches (top,right,bottom,left)
my @deltaYForSide = (0,1,0,-1); # matches (top,right,bottom,left)

my $cardWidth = 4;
my $cardHeight = 5.25;

#
# set up card stack. Sequence board has two decks of cards minus the jacks,
# laid in a circular fashion around a 10x10 grid.  Outermost corners are 
# face-down cards, for a total of 100 cards.

my @stack;

foreach my $suit (@suits) {
    foreach my $name (@names) {
        push @stack, Cards->new(
                                suit=>$suit,
                                name=>$name
                                );
    }
}

foreach (0, 9, 18, 27) {
    my $corner = Cards->new(face=>'back');
    splice (@stack, $_, 0, $corner);
}

#
# set the position of each card, starting at 0,0 (top-left) and 
# moving clockwise around 10x10 grid.

my $cardsInRow = "10";
my $index = 0;
my ($xPos, $yPos) = (0,0);

foreach my $ring (0 .. 5) {
    foreach my $side (0 .. 3) {
        $cardsInRow -=1 if (($side eq 1 or $side eq 3) and ($index > 26 ));
        $cardsInRow = 2 if ($index > 97); 

        foreach (0 .. $cardsInRow - 2) {
            my $style = "left:${xPos}em;top:${yPos}em;";
            
            last if ($index > 99);
            $stack[$index++]->set_style("$style");

            $xPos += $deltaXForSide[$side] * $cardWidth;  
            $yPos += $deltaYForSide[$side] * $cardHeight;
        }
    }
}


# display the board

print CGI::PrintHeader();
print Cards::PrintHeader();

foreach my $card (@stack) {
    $card->print;
}

print Cards::PrintFooter();
